"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.documentStorageConfig = exports.imageStorageConfig = exports.storageConfig = exports.documentFileFilter = exports.imageFileFilter = void 0;
const multer_1 = require("multer");
const path_1 = require("path");
const uuid_1 = require("uuid");
const common_1 = require("@nestjs/common");
const imageFileFilter = (req, file, callback) => {
    if (!file.originalname.match(/\.(jpg|jpeg|png|gif|webp)$/)) {
        return callback(new common_1.HttpException('Only image files (jpg, jpeg, png, gif, webp) are allowed!', common_1.HttpStatus.BAD_REQUEST), false);
    }
    callback(null, true);
};
exports.imageFileFilter = imageFileFilter;
const documentFileFilter = (req, file, callback) => {
    if (!file.originalname.match(/\.(pdf|doc|docx|txt)$/)) {
        return callback(new common_1.HttpException('Only document files (pdf, doc, docx, txt) are allowed!', common_1.HttpStatus.BAD_REQUEST), false);
    }
    callback(null, true);
};
exports.documentFileFilter = documentFileFilter;
exports.storageConfig = {
    storage: (0, multer_1.diskStorage)({
        destination: './uploads/vendors',
        filename: (req, file, callback) => {
            const fileExtName = (0, path_1.extname)(file.originalname);
            const randomName = (0, uuid_1.v4)();
            callback(null, `${randomName}${fileExtName}`);
        },
    }),
};
exports.imageStorageConfig = {
    ...exports.storageConfig,
    fileFilter: exports.imageFileFilter,
    limits: {
        fileSize: 5 * 1024 * 1024,
    },
};
exports.documentStorageConfig = {
    ...exports.storageConfig,
    fileFilter: exports.documentFileFilter,
    limits: {
        fileSize: 10 * 1024 * 1024,
    },
};
//# sourceMappingURL=multer.config.js.map